import json
from pymongo import MongoClient
import glob
import pandas as pd


client = MongoClient()

db1 = client.raw_data
col1 = db1.events_data
col2 = db1.coach


def upload_data_to_mongo():
    events = glob.glob('/Users/paues/Desktop/MASTER/TFM/dades/TEST/b/*.json')
    # events = glob.glob('D:/BIGDATA/Projecte/Bethic/Archive/liga/*events.json')
    # events = glob.glob('/Users/lmjov/Documents/MASTER BIG DATA/Proyecto/Archive/liga/*events.json')
    for filename in events:
        with open(filename) as f:
            file_data = json.load(f)
        col1.insert_one(file_data)
    client.close()

    coach = pd.read_excel('/Users/paues/Desktop/MASTER/TFM/dades/Dataset_entrenadors_d2008.xlsx')
    # coach = pd.read_excel('D:/BIGDATA/Projecte/Bethic/Dataset_entrenadors_d2008.xlsx')
    # coach = pd.read_excel('/Users/lmjov/Documents/MASTER BIG DATA/Proyecto/Jaume/Dataset_entrenadors_d2008.xlsx')
    col2.insert_many(coach.to_dict(orient='records'))


def clean_data_in_mongo():
    db1.events_data.update_many({}, {"$unset":
                                         {"recordCount": "",
                                          "status": "",
                                          "startTimestamp": "",
                                          "endTimestamp": "",
                                          "timeTaken": "",
                                          "sportId": ""}})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.sportId": "",
                                          "apiResults.0.name": ""}})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.league.leagueId": "",
                                          "apiResults.0.league.name": "",
                                          "apiResults.0.league.abbreviation": "",
                                          "apiResults.0.league.displayName": ""}})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.league.leagueId": "",
                                          "apiResults.0.league.name": "",
                                          "apiResults.0.league.abbreviation": "",
                                          "apiResults.0.league.displayName": ""}})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.league.season.name": "",
                                          "apiResults.0.league.season.isActive": ""}})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.league.season.eventType.0.eventTypeId": "",
                                          "apiResults.0.league.season.eventType.0.name": ""}})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.league.season.eventType.0.events.0.isTba": "",
                                          "apiResults.0.league.season.eventType.0.events.0.isDataConfirmed": "",
                                          "apiResults.0.league.season.eventType.0.events.0.tvStations": "",
                                          "apiResults.0.league.season.eventType.0.events.0.replay": "",
                                          "apiResults.0.league.season.eventType.0.events.0.coverageLevel": "",
                                          "apiResults.0.league.season.eventType.0.events.0.eventStatus": "",
                                          }})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.league.season.eventType.0.events.0.venue.venueId": "",
                                          "apiResults.0.league.season.eventType.0.events.0.venue.country": ""
                                          }})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.league.season.eventType.0.events.0.teams.0.teamColors": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.0.location": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.0.abbreviation": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.0.shootoutGoals": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.0.teamLocationType": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.0.linescores": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.0.record.percentage": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.1.teamColors": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.1.location": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.1.abbreviation": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.1.shootoutGoals": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.1.teamLocationType": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.1.linescores": "",
                                          "apiResults.0.league.season.eventType.0.events.0.teams.1.record.percentage": ""
                                          }})

    db1.events_data.update_many({}, {"$unset":
        {
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.benchPlayers": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.teamStats.minutesPlayed": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.teamStats.shots.blocked": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.teamStats.shots.shotResult": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.teamStats.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.teamStats.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.teamStats.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.teamStats.attacks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.teamStats.possessionPercentageBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.goaltenders": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.benchPlayers": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.teamStats.minutesPlayed": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.teamStats.shots.blocked": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.teamStats.shots.shotResult": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.teamStats.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.teamStats.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.teamStats.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.teamStats.attacks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.teamStats.possessionPercentageBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.goaltenders": ""
        }})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.league.season.eventType.0.events.0.suspendedResumeDate": "",
                                          "apiResults.0.league.season.eventType.0.events.0.makeupEventId": "",
                                          "apiResults.0.league.season.eventType.0.events.0.makeupDate": ""
                                          }})

    db1.events_data.update_many({}, {"$unset":
        {
            "apiResults.0.league.season.eventType.0.events.0.gameDetail.refereeAssistants": "",
            "apiResults.0.league.season.eventType.0.events.0.gameDetail.fourthOfficial": ""
        }})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.league.season.eventType.0.events.0.periodDetails": "",
                                          "apiResults.0.league.season.eventType.0.events.0.pbp": "",
                                          "apiResults.0.league.season.eventType.0.events.0.defendingXZeroTeam": "",
                                          "apiResults.0.league.season.eventType.0.events.0.breakdowns": "",
                                          "apiResults.0.league.season.eventType.0.events.0.touches": "",
                                          "apiResults.0.league.season.eventType.0.events.0.playerTouches": ""
                                          }})

    db1.events_data.update_many({}, {"$unset":
                                         {"apiResults.0.league.season.eventType.0.events.0.startDate.1": ""
                                          }})

    db1.events_data.update_many({}, {"$unset":
        {
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.0.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.1.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.2.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.3.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.4.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.5.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.6.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.7.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.8.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.9.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.10.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.11.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.12.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.13.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.0.players.14.clears": ""
        }})

    db1.events_data.update_many({}, {"$unset":
        {
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.aerialDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.assists": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.averagePosition": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.chancesCreated": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.cornerKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.crossBreakdown": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.crosses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.formation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.foulsSuffered": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.goalMouthBlocks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.groundDuels": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.isOnPitch": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.keyPasses": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.offsides": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.ownGoals": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.passLength": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.penaltyKicks": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.player.shirtName": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.player.uniform": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.position.name": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.position.abbreviation": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.possessionAdvanced": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.redCards": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.tackles": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.touches": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.0.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.1.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.2.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.3.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.4.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.5.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.6.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.7.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.8.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.9.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.10.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.11.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.12.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.13.clears": "",
            "apiResults.0.league.season.eventType.0.events.0.boxscores.1.players.14.clears": ""
        }})
